/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.erb.html.outline;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.erb.ERBEditorPlugin;
import com.aptana.editor.erb.html.parsing.ERBScript;
import com.aptana.editor.html.outline.HTMLOutlineLabelProvider;
import com.aptana.editor.ruby.outline.RubyOutlineLabelProvider;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.ruby.core.IRubyScript;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class RHTMLOutlineLabelProvider
extends HTMLOutlineLabelProvider {
    private static final Image ERB_ICON = ERBEditorPlugin.getImage("icons/embedded_code_fragment.png");
    private static final int TRIM_TO_LENGTH = 20;
    private IDocument fDocument;

    public RHTMLOutlineLabelProvider(IDocument document) {
        this.fDocument = document;
        this.addSubLanguage("com.aptana.contenttype.ruby", (ILabelProvider)new RubyOutlineLabelProvider());
    }

    public Image getImage(Object element) {
        IParseNode node;
        if (element instanceof CommonOutlineItem && (node = ((CommonOutlineItem)element).getReferenceNode()) instanceof ERBScript) {
            return ERB_ICON;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        IParseNode node;
        if (element instanceof CommonOutlineItem && (node = ((CommonOutlineItem)element).getReferenceNode()) instanceof ERBScript) {
            return this.getDisplayText((ERBScript)node);
        }
        return super.getText(element);
    }

    private String getDisplayText(ERBScript script) {
        StringBuilder text = new StringBuilder();
        text.append(script.getStartTag());
        IRubyScript ruby = script.getScript();
        int start = Math.max(ruby.getStartingOffset(), 0);
        int endIndex = Math.min(ruby.getEndingOffset(), this.fDocument.getLength());
        try {
            Object source = this.fDocument.get(start, endIndex - start + 1);
            Object[] parts = StringUtil.LINE_SPLITTER.split((CharSequence)source);
            if (!ArrayUtil.isEmpty((Object[])parts)) {
                source = parts[0];
            }
            text.append(StringUtil.truncate((String)source, (int)20));
            String textString = text.toString();
            String end = script.getEndTag();
            if (textString.endsWith(end)) {
                return textString;
            }
            if (!textString.endsWith(" ")) {
                return String.valueOf(textString) + ' ' + end;
            }
            return String.valueOf(textString) + end;
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)ERBEditorPlugin.getDefault(), (Throwable)e);
            return "";
        }
    }
}

